#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int simulirajTurnir(vector<int>& snage, const vector<pair<int, int>>& zamene) {
    for (const auto& zamena : zamene) {
        swap(snage[zamena.first - 1], snage[zamena.second - 1]);
    }

    int runde = 0;
    while (snage.size() > 1) {
        runde++;
        vector<int> sledeciKrug;
        for (size_t i = 0; i < snage.size(); i += 2) {
            sledeciKrug.push_back(max(snage[i], snage[i + 1]));
        }
        snage = move(sledeciKrug);
    }
    return runde;
}

int main() {
    int N;
    cin >> N;

    vector<int> snage(N);
    for (int i = 0; i < N; ++i) {
        cin >> snage[i];
    }

    int Q;
    cin >> Q;

    vector<pair<int, int>> opcije(Q);
    for (int i = 0; i < Q; ++i) {
        cin >> opcije[i].first >> opcije[i].second;
    }

    vector<int> rezultati;
    for (const auto& opcija : opcije) {
        int M = opcija.first;
        int J = opcija.second;
        vector<pair<int, int>> zamene;
        for (int i = 0; i < min(J, N); ++i) {
            zamene.emplace_back(M, i + 1);
        }

        rezultati.push_back(simulirajTurnir(snage, zamene));
    }

    for (int rezultat : rezultati) {
        cout << rezultat << endl;
    }

    return 0;
}